<?php
/**
 * Panel de Administración - Cotizaciones Públicas
 * 
 * URL: /admin/solicitudes.php
 * 
 * IMPORTANTE: Agregar autenticación antes de usar en producción
 */

session_start();

// =====================================================
// CONFIGURACIÓN
// =====================================================
$config = [
    'host' => 'localhost',
    'dbname' => 'ataralcl_export',  // ← Cambiar
    'user' => 'root',               // ← Cambiar
    'pass' => '',                   // ← Cambiar
    'charset' => 'utf8mb4'
];

// Autenticación básica (cambiar en producción)
$adminUser = 'admin';
$adminPass = 'aflcargo2024';  // ← CAMBIAR por contraseña segura

// =====================================================
// AUTENTICACIÓN SIMPLE
// =====================================================
if (!isset($_SESSION['admin_logged_in'])) {
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['login'])) {
        if ($_POST['user'] === $adminUser && $_POST['pass'] === $adminPass) {
            $_SESSION['admin_logged_in'] = true;
        } else {
            $loginError = 'Credenciales incorrectas';
        }
    }
    
    if (!isset($_SESSION['admin_logged_in'])) {
        // Mostrar formulario de login
        ?>
        <!DOCTYPE html>
        <html lang="es">
        <head>
            <meta charset="UTF-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0">
            <title>Admin - AFL Cargo</title>
            <script src="https://cdn.tailwindcss.com"></script>
        </head>
        <body class="min-h-screen bg-gray-900 flex items-center justify-center">
            <div class="bg-gray-800 p-8 rounded-2xl shadow-xl w-full max-w-md">
                <h1 class="text-2xl font-bold text-white mb-6 text-center">🔐 Acceso Admin</h1>
                <?php if (isset($loginError)): ?>
                    <div class="bg-red-500/20 text-red-400 px-4 py-3 rounded-lg mb-4"><?= $loginError ?></div>
                <?php endif; ?>
                <form method="POST">
                    <input type="hidden" name="login" value="1">
                    <div class="mb-4">
                        <label class="block text-gray-400 text-sm mb-2">Usuario</label>
                        <input type="text" name="user" class="w-full px-4 py-3 bg-gray-700 border border-gray-600 rounded-lg text-white focus:outline-none focus:border-purple-500" required>
                    </div>
                    <div class="mb-6">
                        <label class="block text-gray-400 text-sm mb-2">Contraseña</label>
                        <input type="password" name="pass" class="w-full px-4 py-3 bg-gray-700 border border-gray-600 rounded-lg text-white focus:outline-none focus:border-purple-500" required>
                    </div>
                    <button type="submit" class="w-full py-3 bg-purple-600 hover:bg-purple-700 text-white font-semibold rounded-lg transition">Ingresar</button>
                </form>
            </div>
        </body>
        </html>
        <?php
        exit;
    }
}

// Logout
if (isset($_GET['logout'])) {
    session_destroy();
    header('Location: solicitudes.php');
    exit;
}

// =====================================================
// CONEXIÓN A BD
// =====================================================
try {
    $dsn = "mysql:host={$config['host']};dbname={$config['dbname']};charset={$config['charset']}";
    $pdo = new PDO($dsn, $config['user'], $config['pass'], [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
    ]);
} catch (PDOException $e) {
    die('Error de conexión: ' . $e->getMessage());
}

// =====================================================
// ACCIONES
// =====================================================

// Cambiar estado
if (isset($_POST['cambiar_estado'])) {
    $id = intval($_POST['id']);
    $estado = $_POST['estado'];
    $stmt = $pdo->prepare("UPDATE cotizaciones_publicas SET estado = ? WHERE id = ?");
    $stmt->execute([$estado, $id]);
    header('Location: solicitudes.php?msg=Estado actualizado');
    exit;
}

// Asignar
if (isset($_POST['asignar'])) {
    $id = intval($_POST['id']);
    $asignado = $_POST['asignado_a'];
    $stmt = $pdo->prepare("UPDATE cotizaciones_publicas SET asignado_a = ?, fecha_contacto = NOW() WHERE id = ?");
    $stmt->execute([$asignado, $id]);
    header('Location: solicitudes.php?msg=Asignado correctamente');
    exit;
}

// Agregar nota
if (isset($_POST['agregar_nota'])) {
    $id = intval($_POST['id']);
    $nota = $_POST['nota'];
    $stmt = $pdo->prepare("UPDATE cotizaciones_publicas SET notas_internas = CONCAT(IFNULL(notas_internas,''), '\n[', NOW(), '] ', ?) WHERE id = ?");
    $stmt->execute([$nota, $id]);
    header('Location: solicitudes.php?msg=Nota agregada');
    exit;
}

// =====================================================
// OBTENER DATOS
// =====================================================

$filtroEstado = $_GET['estado'] ?? 'todas';
$busqueda = $_GET['q'] ?? '';

$where = "1=1";
$params = [];

if ($filtroEstado !== 'todas') {
    $where .= " AND estado = ?";
    $params[] = $filtroEstado;
}

if ($busqueda) {
    $where .= " AND (nombre LIKE ? OR email LIKE ? OR empresa LIKE ? OR origen LIKE ? OR destino LIKE ?)";
    $buscar = "%$busqueda%";
    $params = array_merge($params, [$buscar, $buscar, $buscar, $buscar, $buscar]);
}

$sql = "SELECT * FROM cotizaciones_publicas WHERE $where ORDER BY fecha_solicitud DESC LIMIT 100";
$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$solicitudes = $stmt->fetchAll();

// Estadísticas
$stats = $pdo->query("
    SELECT 
        COUNT(*) as total,
        SUM(CASE WHEN estado = 'nueva' THEN 1 ELSE 0 END) as nuevas,
        SUM(CASE WHEN estado = 'contactada' THEN 1 ELSE 0 END) as contactadas,
        SUM(CASE WHEN estado = 'cotizada' THEN 1 ELSE 0 END) as cotizadas,
        SUM(CASE WHEN estado = 'cerrada' THEN 1 ELSE 0 END) as cerradas,
        SUM(CASE WHEN DATE(fecha_solicitud) = CURDATE() THEN 1 ELSE 0 END) as hoy
    FROM cotizaciones_publicas
")->fetch();

?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Solicitudes de Cotización - AFL Cargo</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;500;600;700&display=swap" rel="stylesheet">
    <style>
        body { font-family: 'Inter', sans-serif; }
    </style>
</head>
<body class="bg-gray-100 min-h-screen">
    
    <!-- Header -->
    <header class="bg-white shadow-sm border-b">
        <div class="max-w-7xl mx-auto px-4 py-4 flex justify-between items-center">
            <div class="flex items-center space-x-3">
                <div class="w-10 h-10 rounded-xl bg-gradient-to-br from-blue-500 to-purple-600 flex items-center justify-center text-white font-bold">A</div>
                <div>
                    <h1 class="font-bold text-gray-900">AFL Cargo</h1>
                    <p class="text-sm text-gray-500">Panel de Solicitudes</p>
                </div>
            </div>
            <a href="?logout=1" class="text-gray-500 hover:text-red-500 text-sm">Cerrar Sesión</a>
        </div>
    </header>

    <main class="max-w-7xl mx-auto px-4 py-8">
        
        <?php if (isset($_GET['msg'])): ?>
            <div class="bg-green-100 text-green-700 px-4 py-3 rounded-lg mb-6"><?= htmlspecialchars($_GET['msg']) ?></div>
        <?php endif; ?>

        <!-- Stats -->
        <div class="grid grid-cols-2 md:grid-cols-6 gap-4 mb-8">
            <div class="bg-white rounded-xl p-4 shadow-sm">
                <div class="text-2xl font-bold text-gray-900"><?= $stats['hoy'] ?></div>
                <div class="text-sm text-gray-500">Hoy</div>
            </div>
            <div class="bg-white rounded-xl p-4 shadow-sm border-l-4 border-blue-500">
                <div class="text-2xl font-bold text-blue-600"><?= $stats['nuevas'] ?></div>
                <div class="text-sm text-gray-500">Nuevas</div>
            </div>
            <div class="bg-white rounded-xl p-4 shadow-sm border-l-4 border-yellow-500">
                <div class="text-2xl font-bold text-yellow-600"><?= $stats['contactadas'] ?></div>
                <div class="text-sm text-gray-500">Contactadas</div>
            </div>
            <div class="bg-white rounded-xl p-4 shadow-sm border-l-4 border-purple-500">
                <div class="text-2xl font-bold text-purple-600"><?= $stats['cotizadas'] ?></div>
                <div class="text-sm text-gray-500">Cotizadas</div>
            </div>
            <div class="bg-white rounded-xl p-4 shadow-sm border-l-4 border-green-500">
                <div class="text-2xl font-bold text-green-600"><?= $stats['cerradas'] ?></div>
                <div class="text-sm text-gray-500">Cerradas</div>
            </div>
            <div class="bg-white rounded-xl p-4 shadow-sm">
                <div class="text-2xl font-bold text-gray-900"><?= $stats['total'] ?></div>
                <div class="text-sm text-gray-500">Total</div>
            </div>
        </div>

        <!-- Filtros -->
        <div class="bg-white rounded-xl shadow-sm p-4 mb-6">
            <form method="GET" class="flex flex-wrap gap-4 items-center">
                <select name="estado" class="px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-500">
                    <option value="todas" <?= $filtroEstado === 'todas' ? 'selected' : '' ?>>Todas</option>
                    <option value="nueva" <?= $filtroEstado === 'nueva' ? 'selected' : '' ?>>🔵 Nuevas</option>
                    <option value="contactada" <?= $filtroEstado === 'contactada' ? 'selected' : '' ?>>🟡 Contactadas</option>
                    <option value="cotizada" <?= $filtroEstado === 'cotizada' ? 'selected' : '' ?>>🟣 Cotizadas</option>
                    <option value="cerrada" <?= $filtroEstado === 'cerrada' ? 'selected' : '' ?>>🟢 Cerradas</option>
                    <option value="descartada" <?= $filtroEstado === 'descartada' ? 'selected' : '' ?>>⚫ Descartadas</option>
                </select>
                <input type="text" name="q" value="<?= htmlspecialchars($busqueda) ?>" placeholder="Buscar..." class="px-4 py-2 border rounded-lg focus:outline-none focus:ring-2 focus:ring-purple-500 flex-1 min-w-[200px]">
                <button type="submit" class="px-6 py-2 bg-purple-600 text-white rounded-lg hover:bg-purple-700 transition">Filtrar</button>
            </form>
        </div>

        <!-- Tabla de solicitudes -->
        <div class="bg-white rounded-xl shadow-sm overflow-hidden">
            <div class="overflow-x-auto">
                <table class="w-full">
                    <thead class="bg-gray-50 border-b">
                        <tr>
                            <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Fecha</th>
                            <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Cliente</th>
                            <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Ruta</th>
                            <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Tipo</th>
                            <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Peso</th>
                            <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Estimación</th>
                            <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Estado</th>
                            <th class="px-4 py-3 text-left text-xs font-semibold text-gray-500 uppercase">Acciones</th>
                        </tr>
                    </thead>
                    <tbody class="divide-y">
                        <?php foreach ($solicitudes as $s): 
                            $tipoIcon = ['aereo' => '✈️', 'maritimo' => '🚢', 'terrestre' => '🚛'][$s['tipo_transporte']] ?? '📦';
                            $estadoColor = [
                                'nueva' => 'bg-blue-100 text-blue-700',
                                'contactada' => 'bg-yellow-100 text-yellow-700',
                                'cotizada' => 'bg-purple-100 text-purple-700',
                                'cerrada' => 'bg-green-100 text-green-700',
                                'descartada' => 'bg-gray-100 text-gray-700'
                            ][$s['estado']] ?? 'bg-gray-100 text-gray-700';
                        ?>
                        <tr class="hover:bg-gray-50">
                            <td class="px-4 py-4">
                                <div class="text-sm font-medium"><?= date('d/m/Y', strtotime($s['fecha_solicitud'])) ?></div>
                                <div class="text-xs text-gray-500"><?= date('H:i', strtotime($s['fecha_solicitud'])) ?></div>
                            </td>
                            <td class="px-4 py-4">
                                <div class="text-sm font-medium text-gray-900"><?= htmlspecialchars($s['nombre']) ?></div>
                                <?php if ($s['empresa']): ?>
                                    <div class="text-xs text-gray-500"><?= htmlspecialchars($s['empresa']) ?></div>
                                <?php endif; ?>
                                <div class="text-xs text-purple-600"><?= htmlspecialchars($s['email']) ?></div>
                            </td>
                            <td class="px-4 py-4">
                                <div class="text-sm"><?= htmlspecialchars($s['origen']) ?></div>
                                <div class="text-xs text-gray-400">↓</div>
                                <div class="text-sm"><?= htmlspecialchars($s['destino']) ?></div>
                            </td>
                            <td class="px-4 py-4">
                                <span class="text-xl"><?= $tipoIcon ?></span>
                            </td>
                            <td class="px-4 py-4 text-sm">
                                <?= number_format($s['peso_kg'], 0, ',', '.') ?> kg
                            </td>
                            <td class="px-4 py-4 text-sm font-medium text-green-600">
                                $<?= number_format($s['estimacion_min'], 0, ',', '.') ?> - $<?= number_format($s['estimacion_max'], 0, ',', '.') ?>
                            </td>
                            <td class="px-4 py-4">
                                <span class="px-3 py-1 rounded-full text-xs font-medium <?= $estadoColor ?>">
                                    <?= ucfirst($s['estado']) ?>
                                </span>
                            </td>
                            <td class="px-4 py-4">
                                <div class="flex space-x-2">
                                    <a href="https://wa.me/<?= preg_replace('/[^0-9]/', '', $s['telefono']) ?>" target="_blank" class="p-2 hover:bg-green-100 rounded-lg text-green-600" title="WhatsApp">💬</a>
                                    <a href="mailto:<?= $s['email'] ?>" class="p-2 hover:bg-blue-100 rounded-lg text-blue-600" title="Email">📧</a>
                                    <button onclick="openModal(<?= $s['id'] ?>)" class="p-2 hover:bg-purple-100 rounded-lg text-purple-600" title="Gestionar">⚙️</button>
                                </div>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                        
                        <?php if (empty($solicitudes)): ?>
                        <tr>
                            <td colspan="8" class="px-4 py-12 text-center text-gray-500">
                                No hay solicitudes que mostrar
                            </td>
                        </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </main>

    <!-- Modal de gestión -->
    <div id="modal" class="fixed inset-0 bg-black/50 hidden items-center justify-center z-50" onclick="closeModal()">
        <div class="bg-white rounded-2xl max-w-lg w-full mx-4 p-6" onclick="event.stopPropagation()">
            <h3 class="text-lg font-bold mb-4">Gestionar Solicitud</h3>
            <form method="POST" class="space-y-4">
                <input type="hidden" name="id" id="modal-id">
                
                <div>
                    <label class="block text-sm font-medium text-gray-700 mb-1">Cambiar Estado</label>
                    <div class="flex gap-2">
                        <select name="estado" class="flex-1 px-3 py-2 border rounded-lg">
                            <option value="nueva">🔵 Nueva</option>
                            <option value="contactada">🟡 Contactada</option>
                            <option value="cotizada">🟣 Cotizada</option>
                            <option value="cerrada">🟢 Cerrada</option>
                            <option value="descartada">⚫ Descartada</option>
                        </select>
                        <button type="submit" name="cambiar_estado" class="px-4 py-2 bg-purple-600 text-white rounded-lg hover:bg-purple-700">Guardar</button>
                    </div>
                </div>
            </form>
            
            <form method="POST" class="mt-4">
                <input type="hidden" name="id" id="modal-id-nota">
                <label class="block text-sm font-medium text-gray-700 mb-1">Agregar Nota</label>
                <div class="flex gap-2">
                    <input type="text" name="nota" placeholder="Escribir nota..." class="flex-1 px-3 py-2 border rounded-lg">
                    <button type="submit" name="agregar_nota" class="px-4 py-2 bg-gray-600 text-white rounded-lg hover:bg-gray-700">Agregar</button>
                </div>
            </form>
            
            <button onclick="closeModal()" class="mt-6 w-full py-2 border rounded-lg hover:bg-gray-50">Cerrar</button>
        </div>
    </div>

    <script>
        function openModal(id) {
            document.getElementById('modal-id').value = id;
            document.getElementById('modal-id-nota').value = id;
            document.getElementById('modal').classList.remove('hidden');
            document.getElementById('modal').classList.add('flex');
        }
        
        function closeModal() {
            document.getElementById('modal').classList.add('hidden');
            document.getElementById('modal').classList.remove('flex');
        }
    </script>
</body>
</html>
